﻿using System;
using System.Linq;

namespace WindsOfFortuneTest
{
    class Program
    {
        // I want to keep track of all the flavors of wins.
        public static int iTotalRegicides = 0;
        public static int iTotalGreatGames = 0;
        public static int iTotalLettsOfMark = 0;
        public static int iTotalKnightsWager = 0;
        public static int iTotalTradeWinds = 0;
        public static int iTotalWindsOfFortune = 0;
        public static int iTotalWindfall = 0;
        public static int iWinnings = 0;
        public static int iOneRoundWins = 0;

        static void Main(string[] args)
        {

            string sLoopCount = "";
            int iLoopCount = 0;
            char cPlayStyle;
            char[] cPlayStyles = { 'A', 'a', 'C', 'c', 'S', 's', 'E', 'e' };
            bool bLoopAgain = false;
            
            int iTotalWins = 0;
            int iTotalStandardLosses = 0;
            int iTotalKindsOfDaceLosses = 0;

            do // Get our number of games to play
            {
                Console.WriteLine("Please enter the number of games you would like the computer to play:");
                sLoopCount = Console.ReadLine();
                try
                {
                    iLoopCount = Convert.ToInt32(sLoopCount);
                    bLoopAgain = false;
                }
                catch (FormatException)
                {
                    Console.WriteLine("Error: The input is not a valid integer.");
                    bLoopAgain = true;
                }
                catch (OverflowException)
                {
                    Console.WriteLine("Error: The number is too large or too small.");
                    bLoopAgain = true;
                }
            } while (bLoopAgain == true);


            do // Get our strategy method set.
            {
                Console.WriteLine("Please enter the playstyle of the Computer (A For Aggressive, C for Conservative, S for Strategic, or E for Exit:");
                cPlayStyle = Console.ReadKey().KeyChar;

                if (cPlayStyles.Contains(cPlayStyle) != true)
                {
                    Console.WriteLine("Please enter a valid selection.");
                }
            } while (cPlayStyles.Contains(cPlayStyle) != true);

            Console.WriteLine("\r\n\r\n");

            if (cPlayStyle != 'e' || cPlayStyle != 'E')
            {
                for (int i = 0; i < iLoopCount; i++)
                {
                    int[] iDice = { 0, 0, 0, 0 };
                    int iBlackDice = 0;
                    int iRollNumber = 1;
                    int result = 0;

                    result = RollDice(iDice, iBlackDice, iRollNumber, cPlayStyle);

                    switch (result) {
                        case 1:
                            iTotalWins++;
                            break;
                        case 2:
                            iTotalStandardLosses++;
                            break;
                        case 3:
                            iTotalKindsOfDaceLosses++;
                            break;
                        default:
                            Console.WriteLine("Something has gone horribly wrong");
                            break;

                    }

                }

                Console.WriteLine("\r\n\r\n--------------------------------------");
                Console.WriteLine("     Initial starting funds: " + Convert.ToString(iLoopCount * 2));
                Console.WriteLine("               Ending funds: " + Convert.ToString((iLoopCount * 2)+iWinnings));
                Console.WriteLine("--------------------------------------");
                Console.WriteLine("                 Total Wins: " + Convert.ToString(iTotalWins)); 
                Console.WriteLine("      Total Standard Losses: " + Convert.ToString(iTotalStandardLosses));
                Console.WriteLine("  Total King of Dace Losses: " + Convert.ToString(iTotalKindsOfDaceLosses));
                Console.WriteLine("          Round 1 Wins/Loss: " + Convert.ToString(iOneRoundWins));
                Console.WriteLine("--------------------------------------");
                Console.WriteLine("       Total # of Regicides: " + Convert.ToString(iTotalRegicides));
                Console.WriteLine("     Total # of Great Games: " + Convert.ToString(iTotalGreatGames));
                Console.WriteLine("   Total # of Letts of Mark: " + Convert.ToString(iTotalLettsOfMark));
                Console.WriteLine(" Total # of Knight's Wagers: " + Convert.ToString(iTotalKnightsWager));
                Console.WriteLine("     Total # of Trade Winds: " + Convert.ToString(iTotalTradeWinds));
                Console.WriteLine("Total # of Winds of Fortune: " + Convert.ToString(iTotalWindsOfFortune));
                Console.WriteLine("       Total # of Windfalls: " + Convert.ToString(iTotalWindfall));
                


            }

        }

        public static int RollDice(int[] iDice, int iBlackDice, int iRollNumber, char cPlayStyle)
        {
            int iResult = 0;
            Random roller = new Random();
            int iWinds = 0;
            int iSuits = 0;
            int iTarot = 0;
            String[] sDice = {"","","",""};

            if (iRollNumber <= 3)
            {
               

                iBlackDice = roller.Next(1, 7);
            if (iBlackDice != 1)
            {
                for (int i = 0; i < iDice.Length; i++)
                {
                    if (iDice[i] == 0)
                    {
                        iDice[i] = roller.Next(1, 7);


                        switch (iDice[i])
                        {
                            case 1:
                            case 2:
                            case 3:
                                iDice[i] = 1;
                                sDice[i] = "W";
                                iWinds++;
                                break;
                            case 4:
                            case 5:
                                iDice[i] = 2;
                                    sDice[i] = "S";
                                    iSuits++;
                                break;
                            case 6:
                                iDice[i] = 3;
                                sDice[i] = "T";
                                iTarot++;
                                break;
                        }
                    }
                    else
                    {
                        switch (iDice[i])
                        {
                            case 1:
                                iWinds++;
                                sDice[i] = "W";
                                break;
                            case 2:
                                iSuits++;
                                sDice[i] = "S";
                                break;
                            case 3:
                                iTarot++;
                                sDice[i] = "T";
                                break;

                        }
                    }

                }

                    Console.WriteLine("Roll #:" + Convert.ToString(iRollNumber) + " 1:" + sDice[0] + " 2:" + sDice[1] + " 3:" + sDice[2] + " 4:" + sDice[3] + " Fate:" + Convert.ToString(iBlackDice));
                    //lets increment iRoller, expecting our next roll
                    iRollNumber++;

                    switch (cPlayStyle)
                {
                    case 'A':
                    case 'a':
                            if(iWinds == 4 || iSuits == 4 || iTarot == 4)
                            {
                                if (iRollNumber <= 3)
                                    iOneRoundWins++;
                                iResult = CheckForWin(iWinds, iSuits, iTarot, iBlackDice, iRollNumber);
                            }
                            
                            if (iResult == 0)
                            {
                                //1. Aggressive player will always try and attempt for a regicide if their first roll has 2+ tarot results
                                if (iTarot >= 2 && iResult == 0) 
                                {
                                    for (int i = 0; i < iDice.Length; i++)
                                    {
                                        if (iDice[i] != 3)
                                            iDice[i] = 0;
                                    }

                                    if (iTarot == 4)
                                        iDice[3] = 0;

                                    iResult = RollDice(iDice, iBlackDice, iRollNumber, cPlayStyle);
                                }
                                //2. Aggressive player will always favor Suits over Winds
                                if (iSuits >= 2 && iResult == 0)
                                {
                                    for (int i = 0; i < iDice.Length; i++)
                                    {
                                        if (iDice[i] != 2)
                                            iDice[i] = 0;
                                    }
                                    iResult = RollDice(iDice, iBlackDice, iRollNumber, cPlayStyle);
                                }
                                //3. Will play for Winds only as a last resort.
                                if (iWinds >= 2 && iResult == 0)
                                {
                                    for (int i = 0; i < iDice.Length; i++)
                                    {
                                        if (iDice[i] != 1)
                                            iDice[i] = 0;
                                    }
                                    iResult = RollDice(iDice, iBlackDice, iRollNumber, cPlayStyle);
                                }
                            }

                        break;
                    case 'C':
                    case 'c':
                            if (iWinds == 4 || iSuits == 4 || iTarot == 4)
                            {
                                if (iRollNumber <= 3)
                                    iOneRoundWins++;
                                iResult = CheckForWin(iWinds, iSuits, iTarot, iBlackDice, iRollNumber);
                            }
                            
                            if (iResult == 0)
                            {
                                //1. Conservative player will never play for a Regicide
                                //2. Conservative player favors Winds over Suits
                                if (iWinds >= 2 && iResult == 0)
                                {
                                    for (int i = 0; i < iDice.Length; i++)
                                    {
                                        if (iDice[i] != 1)
                                            iDice[i] = 0;
                                    }
                                    iResult = RollDice(iDice, iBlackDice, iRollNumber, cPlayStyle);
                                }

                                //3. Will play for Suits only if 3 or more arrive.
                                if (iSuits >= 2 && iResult == 0)
                                {
                                    for (int i = 0; i < iDice.Length; i++)
                                    {
                                        if (iDice[i] != 2)
                                            iDice[i] = 0;
                                    }
                                    iResult = RollDice(iDice, iBlackDice, iRollNumber, cPlayStyle);
                                }



                                //.4 Else Force Winds.
                                if (iResult == 0)
                                { 
                                    for (int i = 0; i < iDice.Length; i++)
                                    {
                                        if (iDice[i] != 1)
                                            iDice[i] = 0;
                                     }
                                    iResult = RollDice(iDice, iBlackDice, iRollNumber, cPlayStyle);
                                }
                            }

                            break;
                    case 'S':
                    case 's': // Strategic player AI
                            if (iWinds == 4 || iSuits == 4 || iTarot == 4)
                            {
                                if (iRollNumber <= 3)
                                    iOneRoundWins++;
                                iResult = CheckForWin(iWinds, iSuits, iTarot, iBlackDice, iRollNumber);
                            }

                            if (iResult == 0)
                            {
                                //1. Strategic player will always try and attempt for a regicide if their first roll has 2+ tarot results
                                if (iTarot >= 3 && iResult == 0)
                                {
                                    for (int i = 0; i < iDice.Length; i++)
                                    {
                                        if (iDice[i] != 3)
                                            iDice[i] = 0;
                                    }

                                    if (iTarot == 4)
                                        iDice[3] = 0;

                                    iResult = RollDice(iDice, iBlackDice, iRollNumber, cPlayStyle);
                                }


                                //2. will favor winds otherwise
                                if (iWinds >= 2 && iResult == 0)
                                {
                                    for (int i = 0; i < iDice.Length; i++)
                                    {
                                        if (iDice[i] != 1)
                                            iDice[i] = 0;
                                    }
                                    iResult = RollDice(iDice, iBlackDice, iRollNumber, cPlayStyle);
                                }

                                //3. Will favors Suits
                                if (iSuits >= 2 && iResult == 0)
                                {
                                    for (int i = 0; i < iDice.Length; i++)
                                    {
                                        if (iDice[i] != 2)
                                            iDice[i] = 0;
                                    }
                                    iResult = RollDice(iDice, iBlackDice, iRollNumber, cPlayStyle);
                                }

                               

                                //.4 Else Force Winds.
                                if (iResult == 0)
                                {
                                    for (int i = 0; i < iDice.Length; i++)
                                    {
                                        if (iDice[i] != 1)
                                            iDice[i] = 0;
                                    }
                                    iResult = RollDice(iDice, iBlackDice, iRollNumber, cPlayStyle);
                                }

                            }
                            break;
                }
            }
            else
            {
                    if (iRollNumber <= 2)
                        iOneRoundWins++;
                    Console.WriteLine("Loss Via King of Dace");
                    iWinnings -= 2;
                    iResult = 3;
            }

        }
        else
        {
                Console.WriteLine("Loss Via failure to assemble winning combo");
                iWinnings -=  1;
                iResult = 2;
        }

            

            return iResult;
        }

        public static int CheckForWin(int iWinds, int iSuits, int iTarot, int iBlackDice, int iRollNumber)
            {
            int iResult = 0;

            if (iWinds == 4)
            {
                switch(iBlackDice)
                {
                    case 2:
                    case 3:
                        iTotalWindfall++;
                        if (iRollNumber == 2)
                            iWinnings += 2;
                        else
                            iWinnings++;
                        iResult = 1;
                        Console.WriteLine("Win via Windfall!");
                        break;
                    case 4:
                    case 5:
                        iTotalWindsOfFortune++;
                        if (iRollNumber == 2)
                            iWinnings += 4;
                        else
                            iWinnings += 2;
                        iResult = 1;
                        Console.WriteLine("Win via Winds of Fortune!");
                        break;
                    case 6:
                        iTotalTradeWinds++;
                        if (iRollNumber == 2)
                            iWinnings += 4;
                        else
                            iWinnings += 2;
                        Console.WriteLine("Win via Trade Winds!");
                        iResult = 1;
                        break;
                }
            }

            if (iSuits == 4)
            {
                switch (iBlackDice)
                {
                    case 2:
                    case 3:
                        iTotalKnightsWager++;
                        if (iRollNumber == 2)
                            iWinnings += 6;
                        else
                            iWinnings += 3;
                        Console.WriteLine("Win via Knight's Wager!!");
                        iResult = 1;
                        break;
                    case 4:
                    case 5:
                        iTotalLettsOfMark++;
                        if (iRollNumber == 2)
                            iWinnings += 8;
                        else
                            iWinnings += 4;
                        Console.WriteLine("Win via Letter of Mark!!");
                        iResult = 1;
                        break;
                    case 6:
                        iTotalGreatGames++;
                        if (iRollNumber == 2)
                            iWinnings += 10;
                        else
                            iWinnings += 5;
                        Console.WriteLine("Win via The Great Game!!");
                        iResult = 1;
                        break;
                }
            }

            if (iTarot == 4 && iBlackDice == 6)
            {
                iTotalRegicides++;
                if (iRollNumber == 2)
                    iWinnings += 40;
                else
                    iWinnings += 20;
                Console.WriteLine("Win via Regicide!!!");
                iResult = 1;
            }

            return iResult;
            }
      





    }



}
